package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.InrReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface InrReadingRepository extends JpaRepository<InrReading, Long> {
	
     @Query("select a from InrReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<InrReading>  getInrReadingsForUser(@Param ("userprofileid") Long userprofileid);
     
     @Query("select a from InrReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<InrReading>  getDashBoardInrReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
